# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 7
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR7_strategy.txt
# LLM Suggested Fallback: C

def serendipitous_phoenix(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Detect unconditional strategies
    is_always_c = "return \"C\"" in opponent_program_code or "always_cooperate" in opponent_program_code.lower()
    is_always_d = "return \"D\"" in opponent_program_code or "always_defect" in opponent_program_code.lower()
    
    if is_always_c:
        return "D" if current_round > 1 else "C"
    if is_always_d:
        return "C" if current_round % 2 == 1 else "D"
    
    # Initial Phase (Rounds 1-3)
    if current_round <= 3:
        if opp_history and "D" in opp_history[-1:]:
            return "D"
        return "C"
    
    # Middle Phase (Rounds 4-7)
    if current_round <= 7:
        if opp_history and "D" in opp_history[-3:]:
            return opp_history[-1]
        return "C"
    
    # Late Phase (Rounds 8-10)
    if opp_history.count("D") > opp_history.count("C"):
        return "D"
    return "C"